#ifndef __ADC_H
#define __ADC_H

/* 

	ADC System, by Mauro Grassi, September 2010.

*/

/* ADCP is connected to AN4 */

#define ADC_SUPPLY_MIN		(2.70)
#define ADC_SUPPLY_MAX		(3.60)
#define ADC_DENOMINATOR		(4095.0)				/* if 12 bit make sure enabled in config */
#define ADC_SUPPLY_DEFAULT	(3.30)
#define BAND_GAP_VOLTAGE	(1.20)
#define ADCP_CH				4													/* Channel */
#define ADCP_TRIS			(TRISAbits.TRISA5)									/* direction bit */
#define ADCP_PCFG 			(ANCON0bits.PCFG4)									/* config bit */
#define ADC_UR				4700												/* value of the upper divider resistor on the ADCP input */
#define ADC_LR				4700												/* value of the lower divider resistor on the ADCP input */
#define ADC_FACTOR			((float)((float)(ADC_UR+ADC_LR)/(float)(ADC_LR)))	/* factor to multiply value by */
#define ADCP_THRESHOLD		((float)0.9)										/* voltage lower threshold for button sensing (S2) */
#define HIGH_V_DIVIDERS_K	((float)(15000+4700)/(4700))
#define LOW_V_DIVIDERS_K	((float)(470+4700)/(4700))

#define ADC_CH0				0x01
#define ADC_CH1				0x02
#define ADC_CH2				0x04
#define ADC_CH3				0x08

void 					reopenCloseADCObject(unsigned char adcO, unsigned char on);
float 					readADC(unsigned int channel);
float 					readV(unsigned int channel);
unsigned char		 	initADC(void);
unsigned char 			openADCObject(int physicalChannel);
unsigned char 			closeADCObject(int physicalChannel);
float 					getADCP(void);
float 					getADCReference(float denominator, float targetVoltage);
float	 				setADCSupplyVoltage(float x);
float 					getADCSupplyVoltage(void);
void 					calibrateADC(void);
void					setVGBIO(unsigned char);
void					powerADC(unsigned char);

extern float 			adcSupplyVoltage;
extern float 			adcDenominator;
extern float 			adcP;
extern unsigned char 	adcOpen;
extern unsigned char 	adcSave;

#endif
